CPU=$PBS_NP
if [ ! $CPU ]; then
   CPU=2
fi

N=$PBS_ARRAYID
if [ ! $N ]; then
    N=1
fi

#----------------
genome='/public1/home/miyj/sars/data_sports/Homo_sapiens/genome/hg38/genome'
mirbase='/public1/home/miyj/sars/data_sports/Homo_sapiens/miRBase/21/miRBase_21-hsa'
rrnabase='/public1/home/miyj/sars/data_sports/Homo_sapiens/rRNAdb/human_rRNA'
trnabse='/public1/home/miyj/sars/data_sports/Homo_sapiens/GtRNAdb/hg19/hg19'
pirnabase='/public1/home/miyj/sars/data_sports/Homo_sapiens/piRBase/piR_human'
rfam='/public1/home/miyj/sars/data_sports/Homo_sapiens/Rfam/12.3/Rfam-12.3-human'
nocrna='/public1/home/miyj/sars/data_sports/Homo_sapiens/Ensembl/release-89/Homo_sapiens.GRCh38.ncrna'
input='/public1/home/miyj/sars/figs4/input/total'
output='/public1/home/miyj/sras/figs4/input/sports_output'
echo "CPU= $CPU"
echo "FILE= $ctg"
echo "FILE_PREFIX= $prefix"

#if [ ! -e ${prefix} ]; then
   echo "mapping"
   source activate
   conda deactivate
   conda activate SPORTS1.1
   sports.pl -i $input -p $CPU -g $genome -m $mirbase -r $rrnabase -t $trnabse -w $pirnabase -o $output -k -L 50 -M 1 -e $nocrna -f $rfam -z 
#fi

#----------------
end=`date +%s`
runtime=$((end-start))
h=$(($runtime/3600))
hh=$(($runtime%3600))
m=$(($hh/60))
s=$(($hh%60))

echo "Start= $start"
echo "End= $end"
echo "Run time= $h:$m:$s"
echo "Done!"
